package gov.va.genisis2.service.impl;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import java.util.List;

import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import gov.va.genisis2.AbstractMockMvcTests;
import gov.va.genisis2.dao.ICommentHistoryDao;
import gov.va.genisis2.exceptions.GenisisDAOException;
import gov.va.genisis2.exceptions.GenisisServiceException;
import gov.va.genisis2.model.CommentHistory;
import gov.va.genisis2.service.ICommentHistoryService;

/**
 * The Class CommentHistoryServiceTest.
 *
 * @author Prasad Thummalapalli
 * @author Getaneh Kassahun
 * 
 *         The Class CommentHistoryServiceTest.
 * 
 *         Description: Unit test class for CommentHistoryService - uses mock
 *         implementation of CommentHistoryDao
 */
@FixMethodOrder(MethodSorters.NAME_ASCENDING)
public class CommentHistoryServiceTest extends AbstractMockMvcTests {

	/**
	 * The LOGGER.
	 */
	private static final Logger logger = LoggerFactory.getLogger(CommentHistoryServiceTest.class);

	/**
	 * The commentHistoryService.
	 * 
	 */
	@Autowired
	private ICommentHistoryService commentHistoryService;

	/**
	 * The commentHistoryDao.
	 * 
	 */
	@Autowired
	private ICommentHistoryDao commentHistoryDao;

	private CommentHistory commentHistory;

	/**
	 * This method is used to Test createCommentHistorye.
	 * 
	 * @throws GenisisDAOException
	 * @throws GenisisServiceException
	 * 
	 */
	@Test
	public void test1CreateCommentHistory() throws GenisisDAOException, GenisisServiceException {

		logger.info("*****************Test Create CommentHistory*************************");
		commentHistory = commentHistoryDao.getCommentHistoryByCommentId(1);
		assertTrue(commentHistoryService.createCommentHistory(commentHistory) > 0);
		
		List<CommentHistory> commentHistoryList = commentHistoryService.getCommentHistoriesByUID("datamanager1");
		assertEquals(1, commentHistoryList.get(0).getCommentId());
	}

	/**
	 * This method is used to Test createCommentHistorye.
	 * 
	 * @throws GenisisServiceException
	 * 
	 */
	@Test(expected = GenisisServiceException.class)
	public void testCreateCommentHistory2_Null() throws GenisisServiceException {

		logger.info("***************Test Create CommentHistory with null commentHistory*********************");
		commentHistoryService.createCommentHistory(new CommentHistory());

	}

	/**
	 * This method is used to Test UpdateCommentHistory.
	 * 
	 * @throws GenisisDAOException
	 * @throws GenisisServiceException
	 * 
	 */
	@Test
	public void testUpdateCommentHistory() throws GenisisDAOException, GenisisServiceException {

		logger.info("************Test UpdateCommentHistory******************");
		commentHistory = commentHistoryDao.getCommentHistoryByCommentId(1);
		assertEquals(1, commentHistoryService.updateCommentHistory(commentHistory));

	}

	/**
	 * This method is used to Test UpdateCommentHistory.
	 * 
	 * @throws GenisisServiceException
	 * 
	 */
	@Test(expected = GenisisServiceException.class)
	public void testUpdateCommentHistory_Null() throws GenisisServiceException {

		logger.info("************Test UpdateCommentHistory with null CommentHistory******************");
		commentHistoryService.updateCommentHistory(new CommentHistory());

	}

	/**
	 * This method is used to Test getCommentHistoriesByUID.
	 * 
	 * @throws GenisisDAOException
	 * @throws GenisisServiceException
	 * 
	 */
	@Test
	public void test9getCommentHistoriesByUID() throws GenisisDAOException, GenisisServiceException {

		logger.info("************Test getCommentHistoriesByUID******************");
		List<CommentHistory> commentHistoryList = commentHistoryService.getCommentHistoriesByUID("datamanager1");
		assertEquals(1, commentHistoryList.get(0).getCommentId());

	}

	/**
	 * Test submit or modify.
	 * 
	 * @throws GenisisDAOException
	 * @throws GenisisServiceException
	 * 
	 */
	@Test
	public void testSubmitOrModify() throws GenisisDAOException, GenisisServiceException {

		logger.info("************Test SubmitOrModify ******************");
		CommentHistory commentHistory = commentHistoryDao.getCommentHistoryByCommentId(1);
		assertNotNull(commentHistory);
		assertEquals(1, commentHistory.getCommentId());
		commentHistory.setComments("modified description");
		assertNotEquals(0, commentHistoryService.submitOrModify(commentHistory));

	}

	/**
	 * Test submit or modify.
	 * 
	 * @throws GenisisDAOException 
	 * @throws GenisisServiceException
	 * 
	 */
	@Test
	public void testSubmitOrModify_0() throws GenisisDAOException, GenisisServiceException {

		logger.info("************Test SubmitOrModify with 0******************");
		CommentHistory commentHistory = commentHistoryDao.getCommentHistoryByCommentId(1);
		assertNotNull(commentHistory);
		commentHistory.setCommentId(0);
		assertEquals(0, commentHistory.getCommentId());
		assertNotEquals(0, commentHistoryService.submitOrModify(commentHistory));

	}

	/**
	 * Test submit or modify.
	 * 
	 * @throws GenisisServiceException
	 * 
	 */
	@Test(expected = GenisisServiceException.class)
	public void testSubmitOrModify_Null() throws GenisisServiceException {

		logger.info("************Test SubmitOrModify with Null******************");
		commentHistoryService.submitOrModify(new CommentHistory());

	}

	/**
	 * Test get comment history by id.
	 * 
	 * @throws GenisisServiceException
	 * 
	 */
	@Test
	public void testGetCommentHistoryById() throws GenisisServiceException {

		logger.info("************Test getCommentHistoryById******************");
		List<CommentHistory> commentHistories = commentHistoryService.getCommentHistoryById(1);
		assertNotNull(commentHistories);
	}

	/**
	 * Test getCommentHistoryByCommentId.
	 * 
	 * @throws GenisisServiceException
	 * 
	 */
	@Test
	public void testGetCommentHistoryByCommentId() throws GenisisServiceException {

		logger.info("************Test getCommentHistoryByCommentId******************");
		CommentHistory commentHistory = commentHistoryService.getCommentHistoryByCommentId(1);
		assertNotNull(commentHistory);
	}

	/**
	 * Test get CommentHistoryByRequestIdStatusId.
	 * 
	 */
	@Test
	public void testGetCommentHistoryByRequestIdStatusId() throws GenisisServiceException {

		logger.info("************Test getCommentHistoryByRequestIdStatusId******************");
		List<CommentHistory> commentHistories = commentHistoryService.getCommentHistoryByRequestIdStatusId(1, "taskId");
		assertNotNull(commentHistories);
		assertNotNull(commentHistories.get(0));
	}

}
